<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

$is_connected = Wooffinity_CRM::get_instance()->is_connected();
$user_email = get_option('wooffinity_user_email', '');
$store_id = get_option('wooffinity_store_id', '');
$connected_at = get_option('wooffinity_connected_at', '');
?>

<div class="wrap wooffinity-admin-wrap">
    <h1><?php esc_html_e('Wooffinity CRM for WooCommerce', 'wooffinity-crm'); ?></h1>

    <?php if (!$is_connected) : ?>
        <!-- Connection Form -->
        <div class="wooffinity-card">
            <div class="wooffinity-card-header">
                <h2><?php esc_html_e('Connect Your Store to Wooffinity', 'wooffinity-crm'); ?></h2>
                <p><?php esc_html_e('Sync your WooCommerce customers and orders to Wooffinity CRM automatically.', 'wooffinity-crm'); ?></p>
            </div>

            <div class="wooffinity-card-body">
                <form id="wooffinity-connect-form" class="wooffinity-form">
                    <div class="form-group">
                        <label for="wooffinity-email"><?php esc_html_e('Wooffinity Account Email', 'wooffinity-crm'); ?></label>
                        <input
                            type="email"
                            id="wooffinity-email"
                            name="email"
                            class="regular-text"
                            required
                            placeholder="your@email.com"
                        >
                        <p class="description">
                            <?php esc_html_e('Enter the email address you use to login to Wooffinity.', 'wooffinity-crm'); ?>
                        </p>
                    </div>

                    <div class="form-group">
                        <label for="wooffinity-password"><?php esc_html_e('Password', 'wooffinity-crm'); ?></label>
                        <input
                            type="password"
                            id="wooffinity-password"
                            name="password"
                            class="regular-text"
                            required
                            placeholder="Enter your password"
                        >
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="button button-primary button-hero">
                            <span class="dashicons dashicons-cloud"></span>
                            <?php esc_html_e('Connect to Wooffinity', 'wooffinity-crm'); ?>
                        </button>
                    </div>

                    <div class="wooffinity-notice" id="connection-notice" style="display: none;"></div>
                </form>

                <div class="wooffinity-footer">
                    <p>
                        <?php esc_html_e("Don't have a Wooffinity account?", 'wooffinity-crm'); ?>
                        <a href="https://wooffinity.app/pricing" target="_blank" class="button button-secondary">
                            <?php esc_html_e('Sign Up Free', 'wooffinity-crm'); ?>
                        </a>
                    </p>
                </div>
            </div>
        </div>

        <!-- Features Section -->
        <div class="wooffinity-features">
            <h2><?php esc_html_e('Why Connect to Wooffinity?', 'wooffinity-crm'); ?></h2>
            <div class="features-grid">
                <div class="feature-item">
                    <span class="dashicons dashicons-groups"></span>
                    <h3><?php esc_html_e('Customer Management', 'wooffinity-crm'); ?></h3>
                    <p><?php esc_html_e('View all your WooCommerce customers in one powerful dashboard.', 'wooffinity-crm'); ?></p>
                </div>
                <div class="feature-item">
                    <span class="dashicons dashicons-email-alt"></span>
                    <h3><?php esc_html_e('Email Campaigns', 'wooffinity-crm'); ?></h3>
                    <p><?php esc_html_e('Send targeted email campaigns to your customer segments.', 'wooffinity-crm'); ?></p>
                </div>
                <div class="feature-item">
                    <span class="dashicons dashicons-chart-line"></span>
                    <h3><?php esc_html_e('Analytics', 'wooffinity-crm'); ?></h3>
                    <p><?php esc_html_e('Track CLV, churn rate, and other important metrics.', 'wooffinity-crm'); ?></p>
                </div>
                <div class="feature-item">
                    <span class="dashicons dashicons-admin-generic"></span>
                    <h3><?php esc_html_e('Automation', 'wooffinity-crm'); ?></h3>
                    <p><?php esc_html_e('Create workflows to automate your marketing.', 'wooffinity-crm'); ?></p>
                </div>
            </div>
        </div>

    <?php else : ?>
        <!-- Connected State -->
        <div class="wooffinity-card wooffinity-connected">
            <div class="wooffinity-card-header">
                <div class="status-indicator">
                    <span class="dashicons dashicons-yes-alt"></span>
                    <span class="status-text"><?php esc_html_e('Connected', 'wooffinity-crm'); ?></span>
                </div>
                <h2><?php esc_html_e('Your Store is Connected!', 'wooffinity-crm'); ?></h2>
            </div>

            <div class="wooffinity-card-body">
                <div class="connection-info">
                    <div class="info-row">
                        <span class="label"><?php esc_html_e('Account:', 'wooffinity-crm'); ?></span>
                        <span class="value"><?php echo esc_html($user_email); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="label"><?php esc_html_e('Store ID:', 'wooffinity-crm'); ?></span>
                        <span class="value"><?php echo esc_html($store_id); ?></span>
                    </div>
                    <?php if ($connected_at) : ?>
                    <div class="info-row">
                        <span class="label"><?php esc_html_e('Connected:', 'wooffinity-crm'); ?></span>
                        <span class="value"><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($connected_at))); ?></span>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="action-buttons">
                    <a href="https://dashboard.wooffinity.app" target="_blank" class="button button-primary button-hero">
                        <span class="dashicons dashicons-external"></span>
                        <?php esc_html_e('Open Wooffinity Dashboard', 'wooffinity-crm'); ?>
                    </a>

                    <button type="button" id="sync-now-btn" class="button button-secondary">
                        <span class="dashicons dashicons-update"></span>
                        <?php esc_html_e('Sync Now', 'wooffinity-crm'); ?>
                    </button>
                </div>

                <div class="wooffinity-notice" id="sync-notice" style="display: none;"></div>

                <div class="sync-info">
                    <h3><?php esc_html_e('Your Store is Connected!', 'wooffinity-crm'); ?></h3>
                    <p>
                        <span class="dashicons dashicons-yes"></span>
                        <?php esc_html_e('Click "Sync Now" to send your customers and orders to Wooffinity, then manage everything from the dashboard.', 'wooffinity-crm'); ?>
                    </p>
                </div>

                <div class="disconnect-section">
                    <button type="button" id="disconnect-btn" class="button button-link-delete">
                        <?php esc_html_e('Disconnect Store', 'wooffinity-crm'); ?>
                    </button>
                </div>
            </div>
        </div>

        <!-- Quick Stats (placeholder for future) -->
        <div class="wooffinity-stats">
            <h2><?php esc_html_e('Need Advanced Features?', 'wooffinity-crm'); ?></h2>
            <div class="upgrade-cta">
                <p><?php esc_html_e('Unlock email campaigns, automation workflows, advanced analytics, and more.', 'wooffinity-crm'); ?></p>
                <a href="https://wooffinity.app/pricing" target="_blank" class="button button-primary">
                    <?php esc_html_e('View Plans & Pricing', 'wooffinity-crm'); ?>
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>
